unit UnitTEST_USB;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  UnitPortSerieXP, StdCtrls;

type
  TForm1 = class(TForm)
    CheckBoxS1: TCheckBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    ComboBoxCOM: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    procedure Envoi;
    procedure CheckBoxSClick(Sender: TObject);
    procedure ComboBoxCOMChange(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;
  Data:array[1..8] of Boolean;

implementation

{$R *.DFM}


// SELECTION DU PORT COM ET OUVERTURE ==========================================
procedure TForm1.ComboBoxCOMChange(Sender: TObject);
var numcom:integer;
begin
 numCom:=StrToInt(copy(ComboBoxCOM.Text,4,1));
 if not(InitCom(numCom,9600,NOPARITY,ONESTOPBIT)) then
  ShowMessage( 'Impossible d''ouvrir COM'+inttostr(numCom) );
end;


// CHANGEMENT D'ETAT D'UNE SORTIE ==============================================
procedure TForm1.CheckBoxSClick(Sender: TObject);
var i:integer;
begin
i:=((Sender as TCheckBox).Tag);
Data[i]:=(Sender as TCheckBox).Checked;
Envoi;
end;


// PROCEDURE D'ENVOI DES DONNEES AU MONTAGE ====================================
procedure TForm1.Envoi;
var
    Ordre_Data:array[1..8] of Byte;
    i:integer;
begin

 // Ordre dans lequel les donnes doivent tre envoyes-------------------------
 Ordre_Data[1]:=1;
 Ordre_Data[2]:=2;
 Ordre_Data[3]:=3;
 Ordre_Data[4]:=4;
 Ordre_Data[5]:=8;
 Ordre_Data[6]:=7;
 Ordre_Data[7]:=6;
 Ordre_Data[8]:=5;

 // Envoi des donnes via le port srie-----------------------------------------
 DTRon; //STROBE=0
 for i:=8 downto 1 do
 begin
  TXDon; //CLK=0
  if Data[ Ordre_Data[i] ] then RTSoff else RTSon; //DATA
  TXDoff; //CLK=1
 end;
 DTRoff; //STROBE=0

end;


end.
